<?php
/**
 * Plugin Name: Intelligent Inventory Forecaster
 * Plugin URI:  https://intelligentforecaster.com
 * Description: Connects your WooCommerce store to Intelligent Forecaster SaaS for advanced inventory predictions.
 * Version:     1.0.0
 * Author:      Traceflow Pty Ltd
 * Author URI:  https://intelligentforecaster.com
 * License:     GPL-2.0+
 * Text Domain: intelligent-forecaster
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'IIF_VERSION', '1.0.0' );
define( 'IIF_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'IIF_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Main Plugin Class
 */
class Intelligent_Forecaster {

	private static $instance = null;

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {
		$this->includes();
		$this->init_hooks();
	}

	private function includes() {
		require_once IIF_PLUGIN_DIR . 'includes/class-admin-settings.php';
		require_once IIF_PLUGIN_DIR . 'includes/class-api-client.php';
		require_once IIF_PLUGIN_DIR . 'includes/class-data-syncer.php';
	}

	private function init_hooks() {
		add_action( 'plugins_loaded', array( 'IIF_Admin_Settings', 'init' ) );
		// Initialize Syncer logic (scheduling)
		add_action( 'init', array( 'IIF_Data_Syncer', 'init' ) );
	}
}

// Initialize Plugin
function iif_init() {
	Intelligent_Forecaster::get_instance();
}
add_action( 'plugins_loaded', 'iif_init' );
