<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class IIF_API_Client {

	private $api_key;
	private $api_url;

	public function __construct() {
		$this->api_key = get_option( 'iif_api_key' );
		$this->api_url = rtrim( get_option( 'iif_api_url', 'https://api.intelligentforecaster.com/api/v1' ), '/' );
	}

	public function send_forecast_request( $payload ) {
		if ( empty( $this->api_key ) ) {
			return new WP_Error( 'missing_key', 'API Key is missing.' );
		}

		$endpoint = $this->api_url . '/forecast';

		$args = array(
			'body'        => json_encode( $payload ),
			'headers'     => array(
				'Content-Type' => 'application/json',
				'X-API-Key'    => $this->api_key,
			),
			'timeout'     => 45, // Long timeout for calc
			'blocking'    => true, // We wait for the task ID
			'data_format' => 'body',
		);

		$response = wp_remote_post( $endpoint, $args );

		if ( is_wp_error( $response ) ) {
			$this->log( 'API Error: ' . $response->get_error_message() );
			return $response;
		}

		$code = wp_remote_retrieve_response_code( $response );
		$body = wp_remote_retrieve_body( $response );

		if ( $code >= 400 ) {
			$this->log( "API Failed ($code): " . $body );
			return new WP_Error( 'api_error', "Server returned $code: $body" );
		}

		return json_decode( $body, true );
	}

	private function log( $message ) {
		if ( get_option( 'iif_debug_mode' ) ) {
			error_log( '[IIF] ' . $message );
		}
	}
}
