<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class IIF_Admin_Settings {

	public static function init() {
		add_action( 'admin_menu', array( __CLASS__, 'add_admin_menu' ) );
		add_action( 'admin_init', array( __CLASS__, 'register_settings' ) );
	}

	public static function add_admin_menu() {
		add_menu_page(
			'Intelligent Forecaster',
			'Intelligent Forecaster',
			'manage_options',
			'intelligent-forecaster',
			array( __CLASS__, 'settings_page_html' ),
			'dashicons-chart-line',
			56
		);
	}

	public static function register_settings() {
		register_setting( 'iif_options', 'iif_api_key' );
		register_setting( 'iif_options', 'iif_api_url', array( 'default' => 'https://api.intelligentforecaster.com/api/v1' ) );
		register_setting( 'iif_options', 'iif_debug_mode' );
	}

	public static function settings_page_html() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		// Handle manual sync trigger
		if ( isset( $_POST['iif_manual_sync'] ) && check_admin_referer( 'iif_manual_sync_action', 'iif_manual_sync_nonce' ) ) {
			$syncer = new IIF_Data_Syncer();
			$result = $syncer->sync_all_products();
			if ( is_wp_error( $result ) ) {
				echo '<div class="notice notice-error"><p>Sync Failed: ' . esc_html( $result->get_error_message() ) . '</p></div>';
			} else {
				echo '<div class="notice notice-success"><p>Manual Sync Completed successfully!</p></div>';
			}
		}

		?>
		<div class="wrap">
			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<form action="options.php" method="post">
				<?php
				settings_fields( 'iif_options' );
				do_settings_sections( 'iif_options' );
				?>
				<table class="form-table">
					<tr valign="top">
						<th scope="row">SaaS API Key</th>
						<td>
							<input type="text" name="iif_api_key" value="<?php echo esc_attr( get_option( 'iif_api_key' ) ); ?>" class="regular-text" />
							<p class="description">Enter the API Key provided in your Intelligent Forecaster dashboard.</p>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">API URL</th>
						<td>
							<input type="text" name="iif_api_url" value="<?php echo esc_attr( get_option( 'iif_api_url', 'https://api.intelligentforecaster.com/api/v1' ) ); ?>" class="regular-text" />
							<p class="description">Only change this if instructed by support (e.g. for self-hosted instances).</p>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row">Debug Mode</th>
						<td>
							<input type="checkbox" name="iif_debug_mode" value="1" <?php checked( 1, get_option( 'iif_debug_mode' ), true ); ?> />
							<p class="description">Log sync details to <code>wp-content/debug.log</code>.</p>
						</td>
					</tr>
				</table>
				<?php submit_button( 'Save Settings' ); ?>
			</form>

			<hr>

			<h2>Actions</h2>
			<form method="post">
				<?php wp_nonce_field( 'iif_manual_sync_action', 'iif_manual_sync_nonce' ); ?>
				<p>
					<input type="submit" name="iif_manual_sync" class="button button-secondary" value="Run Manual Sync Now" />
					<span class="description"> This will send sales history for all products to the forecaster immediately.</span>
				</p>
			</form>
		</div>
		<?php
	}
}
